<?php $__env->startSection('main-content'); ?>

    <section class="section">
        <div class="section-header">
            <h1><?php echo e(__('Dashboard')); ?></h1>
            <?php echo e(Breadcrumbs::render('dashboard')); ?>

        </div>
        <?php if(auth()->user()->getrole->name == 'Employee'): ?>
        <div class="row">
            <div class="col-lg-6 col-md-6 col-sm-6 col-12">
                <div class="card card-statistic-1">
                    <div class="card-icon bg-primary">
                        <i class="fas fa-users"></i>
                    </div>
                    <div class="card-wrap">
                        <div class="card-header">
                            <h4><?php echo e(__('Total Visitors')); ?></h4>
                        </div>
                        <div class="card-body">
                            <?php echo e($totalVisitor); ?>

                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 col-md-6 col-sm-6 col-12">
                <div class="card card-statistic-1">
                    <div class="card-icon bg-warning">
                        <i class="fas fa-user-secret"></i>
                    </div>
                    <div class="card-wrap">
                        <div class="card-header">
                            <h4><?php echo e(__('Total Pre Registers')); ?></h4>
                        </div>
                        <div class="card-body">
                            <?php echo e($totalPrerigister); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php else: ?>
            <div class="row">
                <div class="col-lg-4 col-md-6 col-sm-6 col-12">
                    <div class="card card-statistic-1">
                        <div class="card-icon bg-danger">
                            <i class="far fa-user"></i>
                        </div>
                        <div class="card-wrap">
                            <div class="card-header">
                                <h4><?php echo e(__('Total Employees')); ?></h4>
                            </div>
                            <div class="card-body">
                                <?php echo e($totalEmployees); ?>

                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-lg-4 col-md-6 col-sm-6 col-12">
                    <div class="card card-statistic-1">
                        <div class="card-icon bg-primary">
                            <i class="fas fa-users"></i>
                        </div>
                        <div class="card-wrap">
                            <div class="card-header">
                                <h4><?php echo e(__('Total Visitors')); ?></h4>
                            </div>
                            <div class="card-body">
                                <?php echo e($totalVisitor); ?>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-6 col-12">
                    <div class="card card-statistic-1">
                        <div class="card-icon bg-warning">
                            <i class="fas fa-user-secret"></i>
                        </div>
                        <div class="card-wrap">
                            <div class="card-header">
                                <h4><?php echo e(__('Total Pre Registers')); ?></h4>
                            </div>
                            <div class="card-body">
                                <?php echo e($totalPrerigister); ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <div class="row">
            <div class="col-md-9">
                <div class="card">
                    <div class="card-header">
                        <h4><?php echo e(__('Visitors')); ?> <span class="badge badge-primary"><?php echo e($totalVisitor); ?></span></h4>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive table-invoice">
                            <table class="table table-striped">
                                <tr>
                                    <th><?php echo e(__('Name')); ?></th>
                                    <th><?php echo e(__('Email')); ?></th>
                                    <th><?php echo e(__('Visitor ID')); ?></th>
                                    <th><?php echo e(__('Employee')); ?></th>
                                    <th><?php echo e(__('Checkin')); ?></th>
                                    <th><?php echo e(__('Action')); ?></th>
                                </tr>
                                    <?php if(!blank($visitors)): ?>
                                        <?php $__currentLoopData = $visitors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $visitor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                if($loop->index > 5) {
                                                    break;
                                                }
                                            ?>
                                            <tr>
                                                <td><?php echo e($visitor->visitor->name); ?></td>
                                                <td><?php echo e($visitor->visitor->email); ?></td>
                                                <td><?php echo e($visitor->reg_no); ?></td>
                                                <td><?php echo e($visitor->employee->user->name); ?></td>
                                                <td><?php echo e(date('d-m-Y h:i A', strtotime($visitor->checkin_at))); ?></td>
                                                <td>
                                                    <a href="<?php echo e(route('admin.visitors.show', $visitor)); ?>" class="btn btn-sm btn-icon btn-primary"><i class="far fa-eye"></i></a>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card">
                    <div class="profile-dashboard bg-maroon-light">
                        <a href="<?php echo e(route('admin.profile')); ?>">
                            <img src="<?php echo e(auth()->user()->images); ?>" alt="">
                        </a>
                        <h1><?php echo e(auth()->user()->name); ?></h1>
                        <p>
                            <?php echo e(auth()->user()->getrole->name ?? ''); ?>

                        </p>
                    </div>
                    <div class="list-group">
                        <li class="list-group-item list-group-item-action"><i class="fa fa-user"></i> <?php echo e(auth()->user()->username); ?></li>
                        <li class="list-group-item list-group-item-action"><i class="fa fa-envelope"></i> <?php echo e(auth()->user()->email); ?></li>
                        <li class="list-group-item list-group-item-action"><i class="fa fa-phone"></i> <?php echo e(auth()->user()->phone); ?></li>
                        <li class="list-group-item list-group-item-action"><i class="fa fa-map"></i> <?php echo e(auth()->user()->address); ?></li>
                    </div>
                </div>
            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>


<?php echo $__env->make('admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\iNilabs_project\vps\resources\views/admin/dashboard/index.blade.php ENDPATH**/ ?>